const app = Vue.createApp({
  setup() {
    document.body.removeAttribute('hidden');
  },
  data() {
    return {
      firstTimeCount: 0,
      countedFirstTimeIds: new Set(),
      targetFirstTimeCount: 0,
      manualInputValue: '',
      timerInputMinutes: 5,
      timerInputSeconds: 0,
      timeLeft: 0,
      timerInterval: null,
      isTimerResetting: false,
    };
  },
  methods: {
    getTotalSetMs() {
      const mins = parseInt(this.timerInputMinutes) || 0;
      const secs = parseInt(this.timerInputSeconds) || 0;
      return (mins * 60 + secs) * 1000;
    },
    startTimer() {
      if (this.timerInterval) return;
      if (this.timeLeft <= 0) {
        this.timeLeft = this.getTotalSetMs();
      }
      this.timerInterval = setInterval(() => {
        if (this.timeLeft > 0) {
          this.timeLeft -= 10;
        } else {
          this.stopTimer();
          this.timeLeft = 0;
        }
      }, 10);
    },
    stopTimer() {
      clearInterval(this.timerInterval);
      this.timerInterval = null;
    },
    resetTimerToFull() {
      this.timeLeft = this.getTotalSetMs();
      this.isTimerResetting = true;
      setTimeout(() => { this.isTimerResetting = false; }, 500);
    },
    formatTime(ms) {
      const minutes = Math.floor(ms / 60000);
      const seconds = Math.floor((ms % 60000) / 1000);
      const centiseconds = Math.floor((ms % 1000) / 10);
      return `${minutes}:${seconds.toString().padStart(2, '0')}:${centiseconds.toString().padStart(2, '0')}`;
    },
    countFirstTime(comment) {
      if (comment.data.isFirstTime && !comment.data.isRepeater && !this.countedFirstTimeIds.has(comment.data.id)) {
        this.countedFirstTimeIds.add(comment.data.id);
        this.triggerCountUp();
      }
    },
    triggerCountUp() {
      // タイマー終了後（0秒以下）は無視する
      if (this.timeLeft <= 0) return; 
      
      this.firstTimeCount++;
      this.resetTimerToFull(); 
    }
  },
  mounted() {
    this.timeLeft = this.getTotalSetMs();
    OneSDK.setup({ mode: "diff", permissions: ['comments'] });
    OneSDK.subscribe({
      action: 'comments',
      callback: (comments) => {
        comments.forEach(comment => this.countFirstTime(comment));
      }
    });
    OneSDK.connect();
  }
});

OneSDK.ready().then(() => { app.mount("#container"); });